<?php
// File: input_testimoni.php
require 'includes/db_connect.php';

$token = $_GET['token'] ?? '';
$msg = '';
$error = '';

// 1. Cek Token Valid Gak?
if (empty($token)) {
    die("Link tidak valid.");
}

$stmt = $pdo->prepare("SELECT * FROM testimoni WHERE token = ?");
$stmt->execute([$token]);
$data = $stmt->fetch();

if (!$data) {
    die("Data serah terima tidak ditemukan atau link kadaluarsa.");
}

// 2. Proses Simpan Testimoni
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nama = $_POST['nama_customer'];
    $rating = $_POST['rating'];
    $ulasan = $_POST['isi_testimoni'];

    try {
        $updateSql = "UPDATE testimoni SET 
                      nama_customer = ?, 
                      rating = ?, 
                      isi_testimoni = ?, 
                      status_isi = 'sudah_diisi' 
                      WHERE token = ?";
        $stmtUp = $pdo->prepare($updateSql);
        $stmtUp->execute([$nama, $rating, $ulasan, $token]);
        
        $msg = "Terima kasih! Testimoni Anda berhasil disimpan.";
        // Refresh data biar tampil
        $stmt->execute([$token]);
        $data = $stmt->fetch();
    } catch (Exception $e) {
        $error = "Gagal menyimpan: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Berikan Testimoni - Tunas Toyota</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .star-rating input { display: none; }
        .star-rating label { cursor: pointer; color: #ddd; font-size: 2rem; transition: color 0.2s; }
        .star-rating input:checked ~ label, .star-rating label:hover, .star-rating label:hover ~ label { color: #facc15; }
        .star-rating { direction: rtl; display: inline-flex; }
    </style>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center p-4">

    <div class="bg-white rounded-2xl shadow-xl max-w-md w-full overflow-hidden">
        <!-- Header Foto -->
        <div class="relative h-48 bg-gray-200">
            <img src="<?= $data['foto_serah_terima_url'] ?>" class="w-full h-full object-cover">
            <div class="absolute inset-0 bg-black/40 flex items-end p-6">
                <div>
                    <span class="bg-red-600 text-white text-xs font-bold px-2 py-1 rounded">Serah Terima Unit</span>
                    <h2 class="text-white text-xl font-bold mt-1 shadow-sm"><?= htmlspecialchars($data['judul_serah_terima']) ?></h2>
                    <p class="text-white/80 text-sm"><?= date('d M Y', strtotime($data['tanggal_serah_terima'])) ?></p>
                </div>
            </div>
        </div>

        <div class="p-8">
            <?php if($msg): ?>
                <div class="text-center py-8">
                    <div class="w-16 h-16 bg-green-100 text-green-600 rounded-full flex items-center justify-center mx-auto mb-4 text-3xl">
                        <i class="fa-solid fa-check"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-800">Terima Kasih!</h3>
                    <p class="text-gray-600 mt-2">Ulasan Anda sangat berarti bagi kami.</p>
                </div>
            <?php else: ?>
                <form method="POST">
                    <div class="mb-6 text-center">
                        <label class="block text-sm font-bold text-gray-700 mb-2">Beri Rating Pelayanan</label>
                        <div class="star-rating">
                            <input type="radio" id="star5" name="rating" value="5" <?= $data['rating']==5 ? 'checked' : '' ?> required/><label for="star5" title="Sempurna"><i class="fa-solid fa-star"></i></label>
                            <input type="radio" id="star4" name="rating" value="4" <?= $data['rating']==4 ? 'checked' : '' ?>/><label for="star4" title="Bagus"><i class="fa-solid fa-star"></i></label>
                            <input type="radio" id="star3" name="rating" value="3" <?= $data['rating']==3 ? 'checked' : '' ?>/><label for="star3" title="Cukup"><i class="fa-solid fa-star"></i></label>
                            <input type="radio" id="star2" name="rating" value="2" <?= $data['rating']==2 ? 'checked' : '' ?>/><label for="star2" title="Kurang"><i class="fa-solid fa-star"></i></label>
                            <input type="radio" id="star1" name="rating" value="1" <?= $data['rating']==1 ? 'checked' : '' ?>/><label for="star1" title="Buruk"><i class="fa-solid fa-star"></i></label>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="block text-sm font-bold text-gray-700 mb-2">Nama Anda</label>
                        <input type="text" name="nama_customer" class="w-full p-3 border rounded-lg bg-gray-50 focus:ring-2 focus:ring-red-500 outline-none" value="<?= htmlspecialchars($data['nama_customer'] ?? '') ?>" required placeholder="Contoh: Pak Budi">
                    </div>

                    <div class="mb-6">
                        <label class="block text-sm font-bold text-gray-700 mb-2">Ulasan / Kesan Pesan</label>
                        <textarea name="isi_testimoni" rows="4" class="w-full p-3 border rounded-lg bg-gray-50 focus:ring-2 focus:ring-red-500 outline-none" required placeholder="Ceritakan pengalaman Anda..."><?= htmlspecialchars($data['isi_testimoni'] ?? '') ?></textarea>
                    </div>

                    <button type="submit" class="w-full bg-red-600 text-white font-bold py-3 rounded-lg hover:bg-red-700 transition shadow-lg">Kirim Ulasan</button>
                </form>
            <?php endif; ?>
        </div>
    </div>

</body>
</html>