<?php
// File: admin/settings.php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (session_status() === PHP_SESSION_NONE) { session_start(); }

require '../includes/db_connect.php';
require '../includes/functions.php';
require '../includes/upload_helper.php';

if (!isset($_SESSION['admin_id'])) { header("Location: login.php"); exit; }

$success = ""; $error = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        $target_config = "../uploads/config/";
        $target_sales = "../uploads/sales/";
        
        // 1. LOGO
        $logo_path = $_POST['existing_logo'] ?? '';
        if (!empty($_FILES['logo_upload']['name'])) {
            deleteFile($logo_path);
            $up = uploadImage($_FILES['logo_upload'], $target_config, "logo", 1000, false);
            if ($up) $logo_path = $up;
        } elseif (!empty($_POST['logo_url']) && $_POST['logo_url'] != $logo_path) {
             $logo_path = $_POST['logo_url'];
        }

        // 2. HERO IMAGE
        $hero_path = $_POST['existing_hero'] ?? '';
        if (!empty($_FILES['hero_upload']['name'])) {
            deleteFile($hero_path);
            $up = uploadImage($_FILES['hero_upload'], $target_config, "hero");
            if ($up) $hero_path = $up;
        } elseif (!empty($_POST['hero_image_url']) && $_POST['hero_image_url'] != $hero_path) {
            $hero_path = $_POST['hero_image_url'];
        }

        // 3. FOTO SALES
        $foto_sales_path = $_POST['existing_sales_foto'] ?? '';
        if (!empty($_FILES['sales_foto_upload']['name'])) {
             deleteFile($foto_sales_path);
             $up = uploadImage($_FILES['sales_foto_upload'], $target_sales, "sales");
             if ($up) $foto_sales_path = $up;
        } elseif (!empty($_POST['sales_foto_url']) && $_POST['sales_foto_url'] != $foto_sales_path) {
             $foto_sales_path = $_POST['sales_foto_url'];
        }

        if (empty($error) || strpos($error, 'Error') === false) {
            // Update Config (TAMBAH GEMINI API KEY)
            $pdo->prepare("UPDATE config_cabang SET nama_cabang=?, brand=?, alamat=?, footer_text=?, logo_url=?, hero_image_url=?, google_map_embed=?, gemini_api_key=? WHERE id=1")
                ->execute([
                    $_POST['nama_cabang'], 
                    $_POST['brand'], 
                    $_POST['alamat'], 
                    $_POST['footer_text'], 
                    $logo_path, 
                    $hero_path, 
                    $_POST['google_map_embed'],
                    $_POST['gemini_api_key'] // Input baru
                ]);

            // Update Sales
            $pdo->prepare("UPDATE sales_profile SET nama_lengkap=?, jabatan=?, no_wa=?, email=?, foto_profil_url=?, instagram_url=?, facebook_url=?, tiktok_url=?, youtube_url=? WHERE id=1")
                ->execute([
                    $_POST['sales_nama'], 
                    $_POST['sales_jabatan'], 
                    $_POST['sales_wa'], 
                    $_POST['sales_email'], 
                    $foto_sales_path, 
                    $_POST['sales_ig'], 
                    $_POST['sales_fb'], 
                    $_POST['sales_tiktok'],
                    $_POST['sales_youtube']
                ]);

            $success = "Pengaturan berhasil disimpan!";
        }

    } catch (Exception $e) { $error = "Gagal: " . $e->getMessage(); }
}

$config = getConfig($pdo);
$sales = getSalesProfile($pdo);

$page_title = 'Web Profile';
require 'includes/header.php';
?>

<main class="flex-1 overflow-y-auto p-6 md:p-10 bg-gray-50 w-full">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold text-gray-800">Pengaturan Website</h2>
    </div>

    <?php if($success): ?><div class="bg-green-100 text-green-700 p-4 rounded mb-6 flex items-center gap-2"><i class="fa-solid fa-check-circle"></i> <?= $success ?></div><?php endif; ?>
    <?php if($error): ?><div class="bg-red-100 text-red-700 p-4 rounded mb-6 flex items-center gap-2"><i class="fa-solid fa-triangle-exclamation"></i> <?= $error ?></div><?php endif; ?>

    <form method="POST" enctype="multipart/form-data" class="space-y-8 pb-20">
        
        <!-- SECTION 1: IDENTITAS & API -->
        <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
            <h3 class="text-lg font-bold mb-4 text-blue-600 flex items-center gap-2">
                <i class="fa-solid fa-desktop"></i> Identitas & Konfigurasi
            </h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-bold mb-2 text-gray-700">Nama Cabang</label>
                    <input type="text" name="nama_cabang" value="<?= htmlspecialchars($config['nama_cabang'] ?? '') ?>" class="w-full border p-3 rounded-lg outline-none">
                </div>
                
                <div>
                    <label class="block text-sm font-bold mb-2 text-gray-700">Brand Mobil</label>
                    <input type="text" name="brand" value="<?= htmlspecialchars($config['brand'] ?? 'Toyota') ?>" class="w-full border p-3 rounded-lg outline-none" placeholder="Contoh: Toyota">
                </div>

                <!-- NEW: API KEY GEMINI -->
                <div class="col-span-1 md:col-span-2">
                    <label class="block text-sm font-bold mb-2 text-gray-700">Google Gemini API Key (Untuk AI Generator)</label>
                    <div class="flex items-center gap-2">
                        <span class="text-xl">🔑</span>
                        <input type="text" name="gemini_api_key" value="<?= htmlspecialchars($config['gemini_api_key'] ?? '') ?>" class="w-full border p-3 rounded-lg outline-none bg-yellow-50 focus:bg-white transition" placeholder="Masukkan API Key Gemini...">
                    </div>
                    <p class="text-xs text-gray-500 mt-1">Dapatkan key gratis di <a href="https://aistudio.google.com/app/apikey" target="_blank" class="text-blue-600 hover:underline">Google AI Studio</a>.</p>
                </div>
                
                <!-- Logo -->
                <div class="col-span-1 md:col-span-2">
                    <label class="block text-sm font-bold mb-2 text-gray-700">Logo Website (PNG/JPG - No Convert)</label>
                    <div class="flex items-start gap-4 bg-gray-50 p-4 rounded-lg border border-dashed border-gray-300">
                        <div class="flex-shrink-0 text-center">
                            <?php if(!empty($config['logo_url'])): ?>
                                <div class="w-20 h-20 flex items-center justify-center bg-white rounded border p-1">
                                    <img src="<?= (strpos($config['logo_url'], 'http') === 0) ? $config['logo_url'] : '../'.$config['logo_url'] ?>" class="max-w-full max-h-full object-contain">
                                </div>
                            <?php endif; ?>
                            <input type="hidden" name="existing_logo" value="<?= $config['logo_url'] ?? '' ?>">
                        </div>
                        <div class="flex-1">
                            <input type="file" name="logo_upload" class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:bg-blue-50 file:text-blue-700 mb-2">
                            <input type="text" name="logo_url" placeholder="https://..." class="w-full p-2 border rounded text-sm mt-2" value="<?= (strpos($config['logo_url'] ?? '', 'http') === 0) ? $config['logo_url'] : '' ?>">
                        </div>
                    </div>
                </div>

                <!-- Hero -->
                <div class="col-span-1 md:col-span-2">
                    <label class="block text-sm font-bold mb-2 text-gray-700">Hero Image (Auto WebP)</label>
                    <div class="flex items-start gap-4 bg-gray-50 p-4 rounded-lg border border-dashed border-gray-300">
                        <div class="flex-shrink-0 text-center">
                            <?php if(!empty($config['hero_image_url'])): ?>
                                <img src="<?= (strpos($config['hero_image_url'], 'http') === 0) ? $config['hero_image_url'] : '../'.$config['hero_image_url'] ?>" class="w-32 h-20 object-cover rounded border">
                            <?php endif; ?>
                            <input type="hidden" name="existing_hero" value="<?= $config['hero_image_url'] ?? '' ?>">
                        </div>
                        <div class="flex-1">
                            <input type="file" name="hero_upload" class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:bg-blue-50 file:text-blue-700 mb-2">
                            <input type="text" name="hero_image_url" placeholder="https://..." class="w-full p-2 border rounded text-sm mt-2" value="<?= (strpos($config['hero_image_url'] ?? '', 'http') === 0) ? $config['hero_image_url'] : '' ?>">
                        </div>
                    </div>
                </div>

                <div class="col-span-1 md:col-span-2">
                    <label class="block text-sm font-bold mb-2 text-gray-700">Link Embed Google Maps</label>
                    <input type="text" name="google_map_embed" value="<?= htmlspecialchars($config['google_map_embed'] ?? '') ?>" class="w-full border p-3 rounded-lg">
                </div>
                <div>
                    <label class="block text-sm font-bold mb-2 text-gray-700">Alamat Lengkap</label>
                    <textarea name="alamat" rows="3" class="w-full border p-3 rounded-lg"><?= htmlspecialchars($config['alamat'] ?? '') ?></textarea>
                </div>
                <div>
                    <label class="block text-sm font-bold mb-2 text-gray-700">Teks Footer</label>
                    <textarea name="footer_text" rows="3" class="w-full border p-3 rounded-lg"><?= htmlspecialchars($config['footer_text'] ?? '') ?></textarea>
                </div>
            </div>
        </div>

        <!-- SECTION 2: SALES -->
        <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
            <h3 class="text-lg font-bold mb-4 text-red-600 flex items-center gap-2"><i class="fa-solid fa-user-tie"></i> Profil Sales</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-bold mb-2 text-gray-700">Nama Sales</label>
                    <input type="text" name="sales_nama" value="<?= htmlspecialchars($sales['nama_lengkap'] ?? '') ?>" class="w-full border p-3 rounded-lg">
                </div>
                <div>
                    <label class="block text-sm font-bold mb-2 text-gray-700">Jabatan</label>
                    <input type="text" name="sales_jabatan" value="<?= htmlspecialchars($sales['jabatan'] ?? '') ?>" class="w-full border p-3 rounded-lg">
                </div>
                <div>
                    <label class="block text-sm font-bold mb-2 text-gray-700">WhatsApp</label>
                    <input type="text" name="sales_wa" value="<?= htmlspecialchars($sales['no_wa'] ?? '') ?>" class="w-full border p-3 rounded-lg">
                </div>
                <div>
                    <label class="block text-sm font-bold mb-2 text-gray-700">Email</label>
                    <input type="email" name="sales_email" value="<?= htmlspecialchars($sales['email'] ?? '') ?>" class="w-full border p-3 rounded-lg">
                </div>
                
                <!-- Foto Sales -->
                <div class="col-span-1 md:col-span-2">
                    <label class="block text-sm font-bold mb-2 text-gray-700">Foto Profil Sales</label>
                    <div class="flex items-start gap-4 bg-gray-50 p-4 rounded-lg border border-dashed border-gray-300">
                        <div class="flex-shrink-0 text-center">
                            <?php if(!empty($sales['foto_profil_url'])): ?>
                                <img src="../<?= $sales['foto_profil_url'] ?>" class="w-20 h-20 rounded-full object-cover border-2 border-white shadow">
                            <?php endif; ?>
                            <input type="hidden" name="existing_sales_foto" value="<?= $sales['foto_profil_url'] ?? '' ?>">
                        </div>
                        <div class="flex-1">
                            <input type="file" name="sales_foto_upload" class="block w-full text-sm mb-2">
                            <input type="text" name="sales_foto_url" placeholder="https://..." class="w-full p-2 border rounded text-sm mt-2" value="<?= (strpos($sales['foto_profil_url'] ?? '', 'http') === 0) ? $sales['foto_profil_url'] : '' ?>">
                        </div>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-bold mb-2 text-gray-700">Instagram</label>
                    <input type="text" name="sales_ig" value="<?= htmlspecialchars($sales['instagram_url'] ?? '') ?>" class="w-full border p-3 rounded-lg">
                </div>
                <div>
                    <label class="block text-sm font-bold mb-2 text-gray-700">Facebook</label>
                    <input type="text" name="sales_fb" value="<?= htmlspecialchars($sales['facebook_url'] ?? '') ?>" class="w-full border p-3 rounded-lg">
                </div>
                <div>
                    <label class="block text-sm font-bold mb-2 text-gray-700">TikTok</label>
                    <input type="text" name="sales_tiktok" value="<?= htmlspecialchars($sales['tiktok_url'] ?? '') ?>" class="w-full border p-3 rounded-lg">
                </div>
                <div>
                    <label class="block text-sm font-bold mb-2 text-gray-700">YouTube</label>
                    <input type="text" name="sales_youtube" value="<?= htmlspecialchars($sales['youtube_url'] ?? '') ?>" class="w-full border p-3 rounded-lg">
                </div>
            </div>
        </div>

        <div class="fixed bottom-6 right-6 md:static md:text-right z-40">
            <button type="submit" class="bg-blue-600 text-white font-bold py-4 px-10 rounded-full md:rounded-lg shadow-xl hover:bg-blue-700 transition flex items-center justify-center gap-2">
                <i class="fa-solid fa-save"></i> Simpan
            </button>
        </div>
    </form>
</main>
<?php require 'includes/footer.php'; ?>