<?php
// File: admin/login.php

// 1. Output Buffering: Menahan output agar header tidak error
ob_start();

// 2. NYALAKAN ERROR REPORTING (Biar ketahuan kalau ada error)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Cek status session sebelum start
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require '../includes/db_connect.php';

// Jika sudah login, lempar ke dashboard
if (isset($_SESSION['admin_id'])) {
    header("Location: dashboard.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    try {
        $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password_hash'])) {
            // Login Sukses
            $_SESSION['admin_id'] = $user['id'];
            
            // Update Last Login
            $pdo->prepare("UPDATE admin_users SET last_login = NOW() WHERE id = ?")->execute([$user['id']]);

            // --- REDIRECT AMAN ---
            if (!headers_sent()) {
                header("Location: dashboard.php");
                exit;
            } else {
                // Fallback JavaScript jika header masih macet
                echo '<script>window.location.href="dashboard.php";</script>';
                echo '<noscript><meta http-equiv="refresh" content="0;url=dashboard.php"></noscript>';
                exit;
            }
        } else {
            $error = "Username atau Password salah!";
        }
    } catch (PDOException $e) {
        $error = "Database Error: " . $e->getMessage();
    }
}

// Flush output buffer
ob_end_flush();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin Sales</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { background-color: #f3f4f6; }
    </style>
</head>
<body class="h-screen flex items-center justify-center">
    
    <div class="bg-white p-8 rounded-xl shadow-2xl w-full max-w-sm border-t-4 border-red-600 mx-4">
        <div class="text-center mb-8">
            <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-red-100 text-red-600 mb-4">
                <i class="fa-solid fa-car-on text-3xl"></i>
            </div>
            <h1 class="text-2xl font-bold text-gray-800">Admin Login</h1>
            <p class="text-sm text-gray-500 mt-1">Toyota Sales System</p>
        </div>
        
        <?php if(!empty($error)): ?>
            <div class="bg-red-50 text-red-600 p-3 rounded-lg mb-6 text-sm flex items-center border border-red-100 animate-pulse">
                <i class="fa-solid fa-circle-exclamation mr-2 text-lg"></i> <?= $error ?>
            </div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="mb-5">
                <label class="block text-gray-700 text-xs font-bold uppercase mb-2 tracking-wider">Username</label>
                <div class="relative">
                    <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-gray-400">
                        <i class="fa-solid fa-user"></i>
                    </span>
                    <input type="text" name="username" class="w-full pl-10 p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 outline-none transition" placeholder="Masukkan username" required>
                </div>
            </div>
            
            <div class="mb-6">
                <div class="flex justify-between items-center mb-2">
                    <label class="block text-gray-700 text-xs font-bold uppercase tracking-wider">Password</label>
                </div>
                <div class="relative">
                    <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-gray-400">
                        <i class="fa-solid fa-lock"></i>
                    </span>
                    <input type="password" name="password" class="w-full pl-10 p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 outline-none transition" placeholder="••••••••" required>
                </div>
                <div class="text-right mt-2">
                    <a href="forgot_password.php" class="text-xs text-red-600 hover:text-red-800 hover:underline">Lupa Password?</a>
                </div>
            </div>
            
            <button type="submit" class="w-full bg-red-600 text-white font-bold py-3 px-4 rounded-lg hover:bg-red-700 transition duration-300 shadow-lg transform hover:-translate-y-0.5">
                Masuk Dashboard <i class="fa-solid fa-arrow-right ml-2"></i>
            </button>
        </form>

        <div class="mt-8 text-center border-t border-gray-100 pt-4">
            <a href="../index.php" class="text-sm text-gray-400 hover:text-gray-600 flex items-center justify-center gap-2">
                <i class="fa-solid fa-house"></i> Kembali ke Website
            </a>
        </div>
    </div>

</body>
</html>