<?php
// Dapatkan nama file saat ini untuk penanda menu aktif
$current_page = basename($_SERVER['PHP_SELF']);
// Hapus query string jika ada (misal: ?view=add)
$current_page = strtok($current_page, '?');

// Fungsi helper untuk cek aktif
function isActive($pageName, $currentPage) {
    // Jika nama file sama, return class active (Merah)
    // Jika beda, return class inactive (Hover effect)
    if ($currentPage == $pageName) {
        return 'bg-red-600 text-white shadow-md';
    } else {
        return 'text-gray-400 hover:bg-gray-800 hover:text-white transition-colors duration-200';
    }
}
?>

<!-- SIDEBAR CONTAINER -->
<aside class="w-64 bg-gray-900 hidden md:flex flex-col h-full border-r border-gray-800 shrink-0 transition-all duration-300" id="sidebar">
    
    <!-- 1. LOGO HEADER -->
    <div class="h-16 flex items-center px-6 border-b border-gray-800 bg-gray-900">
        <i class="fa-solid fa-car-on text-red-600 text-2xl mr-3"></i>
        <h1 class="text-xl font-bold text-red-600 tracking-wider">ADMIN</h1>
    </div>

    <!-- 2. MENU LIST (Scrollable) -->
    <div class="flex-1 overflow-y-auto custom-scrollbar py-6 px-4 space-y-1">
        
        <!-- SECTION: UTAMA -->
        <p class="px-4 text-xs font-bold text-gray-500 uppercase tracking-wider mb-2 mt-2">
            Utama
        </p>

        <a href="dashboard.php" class="flex items-center px-4 py-3 rounded-xl mb-1 <?php echo isActive('dashboard.php', $current_page); ?>">
            <div class="w-8 flex justify-center">
                <i class="fa-solid fa-gauge-high text-lg"></i>
            </div>
            <span class="font-medium">Dashboard</span>
        </a>

        <!-- SECTION: KONTEN WEBSITE -->
        <p class="px-4 text-xs font-bold text-gray-500 uppercase tracking-wider mb-2 mt-6">
            Konten Website
        </p>

        <a href="settings.php" class="flex items-center px-4 py-3 rounded-xl mb-1 <?php echo isActive('settings.php', $current_page); ?>">
            <div class="w-8 flex justify-center">
                <i class="fa-solid fa-gear text-lg"></i>
            </div>
            <span class="font-medium">Web Profile</span>
        </a>

        <a href="credit_settings.php" class="flex items-center px-4 py-3 rounded-xl mb-1 <?php echo isActive('credit_settings.php', $current_page); ?>">
            <div class="w-8 flex justify-center">
                <i class="fa-solid fa-calculator text-lg"></i>
            </div>
            <span class="font-medium">Rate Kredit</span>
        </a>

        <a href="crud_produk.php" class="flex items-center px-4 py-3 rounded-xl mb-1 <?php echo isActive('crud_produk.php', $current_page); ?>">
            <div class="w-8 flex justify-center">
                <i class="fa-solid fa-car text-lg"></i>
            </div>
            <span class="font-medium">Data Produk</span>
        </a>

        <a href="crud_promo.php" class="flex items-center px-4 py-3 rounded-xl mb-1 <?php echo isActive('crud_promo.php', $current_page); ?>">
            <div class="w-8 flex justify-center">
                <i class="fa-solid fa-tags text-lg"></i>
            </div>
            <span class="font-medium">Promo</span>
        </a>

        <a href="crud_artikel.php" class="flex items-center px-4 py-3 rounded-xl mb-1 <?php echo isActive('crud_artikel.php', $current_page); ?>">
            <div class="w-8 flex justify-center">
                <i class="fa-solid fa-newspaper text-lg"></i>
            </div>
            <span class="font-medium">Artikel</span>
        </a>

        <!-- MENU BARU: AI GENERATOR -->
        <a href="ai_generator.php" class="flex items-center px-4 py-3 rounded-xl mb-1 group relative <?php echo isActive('ai_generator.php', $current_page); ?>">
            <div class="w-8 flex justify-center">
                <!-- Icon Magic Wand warna Orange biar beda dikit -->
                <i class="fa-solid fa-wand-magic-sparkles text-lg <?php echo ($current_page == 'ai_generator.php') ? 'text-white' : 'text-orange-500'; ?>"></i>
            </div>
            <div class="flex-1">
                <span class="font-medium block">AI Generator</span>
                <span class="text-[10px] opacity-70 block font-normal -mt-0.5">Bikin Konten Kilat</span>
            </div>
            <!-- Badge NEW -->
            <span class="absolute right-3 top-3 bg-red-100 text-red-600 text-[9px] font-bold px-1.5 py-0.5 rounded">NEW</span>
        </a>

        <a href="crud_testimoni.php" class="flex items-center px-4 py-3 rounded-xl mb-1 <?php echo isActive('crud_testimoni.php', $current_page); ?>">
            <div class="w-8 flex justify-center">
                <i class="fa-solid fa-comments text-lg"></i>
            </div>
            <span class="font-medium">Testimoni</span>
        </a>

        <!-- SECTION: AKUN SAYA -->
        <p class="px-4 text-xs font-bold text-gray-500 uppercase tracking-wider mb-2 mt-6">
            Akun Saya
        </p>

        <a href="change_password.php" class="flex items-center px-4 py-3 rounded-xl mb-1 <?php echo isActive('change_password.php', $current_page); ?>">
            <div class="w-8 flex justify-center">
                <i class="fa-solid fa-lock text-lg"></i>
            </div>
            <span class="font-medium">Ganti Password</span>
        </a>

        <a href="logout.php" class="flex items-center px-4 py-3 rounded-xl mb-1 text-gray-400 hover:bg-red-900 hover:text-red-200 transition-colors mt-4">
            <div class="w-8 flex justify-center">
                <i class="fa-solid fa-right-from-bracket text-lg"></i>
            </div>
            <span class="font-medium">Keluar</span>
        </a>
        
        <!-- Footer Kecil -->
        <div class="mt-8 text-center px-4 pb-4">
            <p class="text-[10px] text-gray-600">
                &copy; 2026 Tunas Toyota Ciputat<br>
                Ver 2.0 (AI Enabled)
            </p>
        </div>

    </div>
</aside>

<!-- SCRIPT PENDUKUNG AGAR RESPONSIVE DI HP (Opsional jika belum ada) -->
<script>
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        sidebar.classList.toggle('hidden');
        sidebar.classList.toggle('absolute');
        sidebar.classList.toggle('z-50');
        sidebar.classList.toggle('h-screen');
    }
</script>