<?php
// File: admin/includes/header.php

// Cek session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Cek Login
if (!isset($_SESSION['admin_id'])) { 
    header("Location: login.php"); 
    exit; 
}

// Pastikan functions.php ter-load untuk ambil config
if (!function_exists('getConfig')) {
    require_once __DIR__ . '/../../includes/db_connect.php';
    require_once __DIR__ . '/../../includes/functions.php';
}

// Ambil Config buat Logo/Favicon
if (!isset($config)) {
    $config = getConfig($pdo);
}

// Logic Path Favicon: Kalau lokal, tambah '../'
$favicon_url = $config['logo_url'] ?? '';
if ($favicon_url && strpos($favicon_url, 'http') !== 0) {
    $favicon_url = '../' . $favicon_url;
}

$page_title = isset($page_title) ? $page_title : 'Admin Panel';
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title ?> - Tunas Toyota Admin</title>
    
    <!-- FAVICON (Mengambil dari Logo) -->
    <link rel="shortcut icon" href="<?= $favicon_url ?>" type="image/x-icon">
    
    <!-- Libraries -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom Styles -->
    <style>
        .custom-scrollbar::-webkit-scrollbar { width: 6px; }
        .custom-scrollbar::-webkit-scrollbar-track { background: #1f2937; }
        .custom-scrollbar::-webkit-scrollbar-thumb { background: #4b5563; border-radius: 3px; }
        .custom-scrollbar::-webkit-scrollbar-thumb:hover { background: #6b7280; }
    </style>
    
    <!-- Script Helper Global -->
    <script>
        function formatRupiahInput(input) {
            let value = input.value.replace(/\D/g, '');
            input.value = new Intl.NumberFormat('id-ID').format(value);
        }
    </script>
</head>
<body class="bg-gray-100 font-sans antialiased overflow-hidden">
    
    <div class="flex h-screen relative">
        <!-- 1. Include Sidebar -->
        <?php include __DIR__ . '/sidebar.php'; ?>

        <!-- 2. Content Wrapper -->
        <div class="flex-1 flex flex-col h-screen overflow-hidden relative w-full">
            
            <!-- MOBILE HEADER (Sticky Top) -->
            <header class="bg-white shadow-sm z-30 md:hidden flex items-center justify-between p-4 sticky top-0 w-full shrink-0">
                <button onclick="toggleSidebar()" class="text-gray-600 focus:outline-none hover:text-red-600 p-2 rounded-md hover:bg-gray-100 transition">
                    <i class="fa-solid fa-bars text-2xl"></i>
                </button>
                <span class="font-bold text-gray-800 text-lg flex items-center gap-2">
                    <i class="fa-solid fa-car-on text-red-600"></i> <?= $page_title ?>
                </span>
                <div class="w-8"></div> <!-- Spacer -->
            </header>

            <!-- MAIN CONTENT CONTAINER -->
            <main class="flex-1 overflow-y-auto p-6 md:p-10 bg-gray-50 w-full">