<?php
// File: admin/dashboard.php
require '../includes/db_connect.php';
require '../includes/functions.php'; // Butuh fungsi getSalesProfile

// Set Judul Halaman & Load Header
$page_title = 'Dashboard';
require 'includes/header.php';

// --- LOGIC PERHITUNGAN DATA ---
try {
    // 1. Total Produk
    $stmtProd = $pdo->query("SELECT COUNT(*) FROM produk");
    $totalProduk = $stmtProd->fetchColumn();
    
    // 2. Total Testimoni
    $stmtTesti = $pdo->query("SELECT COUNT(*) FROM testimoni");
    $totalTesti = $stmtTesti->fetchColumn();

    // 3. Total Visitor (Dari Config)
    $stmtVisit = $pdo->query("SELECT visit_count FROM config_cabang LIMIT 1");
    $totalVisitor = $stmtVisit->fetchColumn() ?: 0;

    // 4. Total Leads (Klik WA: Simulasi, Trade-In, Kontak)
    $stmtLeads = $pdo->query("SELECT COUNT(*) FROM leads_log");
    $totalLeads = $stmtLeads->fetchColumn();

    // 5. Top 5 Mobil Paling Diminati (Lead Tracker)
    $stmtTop = $pdo->query("SELECT detail, COUNT(*) as count FROM leads_log WHERE detail != 'General' GROUP BY detail ORDER BY count DESC LIMIT 5");
    $topInterests = $stmtTop->fetchAll();

    // 6. Nama Sales buat Sapaan
    $salesData = getSalesProfile($pdo);
    $salesName = $salesData['nama_lengkap'] ?? 'Admin';
    $firstName = explode(' ', trim($salesName))[0]; // Ambil nama depan

} catch (Exception $e) { 
    $totalProduk = 0; $totalTesti = 0; $totalVisitor = 0; $totalLeads = 0; $topInterests = []; $firstName = 'Admin';
}
?>

<!-- === KONTEN DASHBOARD === -->

<!-- 1. GREETING -->
<div class="mb-8">
    <h2 class="text-3xl font-bold text-gray-800">Selamat Datang, Bro <?= htmlspecialchars($firstName) ?>! 👋</h2>
    <p class="text-gray-500 mt-1">Berikut ringkasan performa website sales Anda hari ini.</p>
</div>

<!-- 2. STATISTIK CARDS (4 Kolom) -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-10">
    
    <!-- Card Stok Unit -->
    <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex justify-between items-center hover:shadow-md transition group">
        <div>
            <h3 class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-1">Total Produk</h3>
            <p class="text-3xl font-extrabold text-gray-800"><?= number_format($totalProduk) ?></p>
            <a href="crud_produk" class="text-xs text-blue-600 font-bold mt-2 inline-block hover:underline">Kelola Mobil &rarr;</a>
        </div>
        <div class="p-3 bg-blue-50 text-blue-600 rounded-xl group-hover:bg-blue-600 group-hover:text-white transition">
            <i class="fa-solid fa-car-side text-2xl"></i>
        </div>
    </div>

    <!-- Card Visitor -->
    <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex justify-between items-center hover:shadow-md transition group">
        <div>
            <h3 class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-1">Kunjungan Web</h3>
            <p class="text-3xl font-extrabold text-gray-800"><?= number_format($totalVisitor) ?></p>
            <span class="text-xs text-purple-600 font-bold mt-1 inline-block">Traffic</span>
        </div>
        <div class="p-3 bg-purple-50 text-purple-600 rounded-xl group-hover:bg-purple-600 group-hover:text-white transition">
            <i class="fa-solid fa-eye text-2xl"></i>
        </div>
    </div>

    <!-- Card Total Leads (Klik WA) -->
    <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex justify-between items-center hover:shadow-md transition group">
        <div>
            <h3 class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-1">Total Leads WA</h3>
            <p class="text-3xl font-extrabold text-gray-800"><?= number_format($totalLeads) ?></p>
            <span class="text-xs text-red-600 font-bold mt-1 inline-block">Calon Buyer</span>
        </div>
        <div class="p-3 bg-red-50 text-red-600 rounded-xl group-hover:bg-red-600 group-hover:text-white transition">
            <i class="fa-brands fa-whatsapp text-2xl"></i>
        </div>
    </div>

    <!-- Card Testimoni -->
    <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 flex justify-between items-center hover:shadow-md transition group">
        <div>
            <h3 class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-1">Testimoni</h3>
            <p class="text-3xl font-extrabold text-gray-800"><?= number_format($totalTesti) ?></p>
            <a href="crud_testimoni" class="text-xs text-green-600 font-bold mt-2 inline-block hover:underline">Lihat Review &rarr;</a>
        </div>
        <div class="p-3 bg-green-50 text-green-600 rounded-xl group-hover:bg-green-600 group-hover:text-white transition">
            <i class="fa-solid fa-star text-2xl"></i>
        </div>
    </div>
</div>

<!-- 3. TABEL LEAD TRACKER -->
<div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 mb-10">
    <div class="flex justify-between items-center mb-4">
        <h3 class="text-lg font-bold text-gray-800 flex items-center gap-2">
            <i class="fa-solid fa-fire text-orange-500"></i> Mobil Paling Banyak Ditanyakan
        </h3>
        <span class="text-xs bg-gray-100 text-gray-500 px-2 py-1 rounded">Realtime Data</span>
    </div>

    <?php if(empty($topInterests)): ?>
        <div class="p-8 text-center text-gray-400 border border-dashed rounded-lg">
            Belum ada data leads yang masuk.
        </div>
    <?php else: ?>
        <div class="overflow-x-auto">
            <table class="w-full text-left">
                <thead class="bg-gray-50 text-gray-500 text-xs uppercase">
                    <tr>
                        <th class="p-3 rounded-tl-lg">Model Mobil</th>
                        <th class="p-3">Jumlah Klik WA</th>
                        <th class="p-3 rounded-tr-lg w-1/3">Minat</th>
                    </tr>
                </thead>
                <tbody class="text-sm text-gray-700">
                    <?php foreach($topInterests as $row): 
                        $percent = ($totalLeads > 0) ? ($row['count'] / $totalLeads) * 100 : 0;
                    ?>
                    <tr class="border-b last:border-0 hover:bg-gray-50 transition">
                        <td class="p-3 font-bold"><?= htmlspecialchars($row['detail']) ?></td>
                        <td class="p-3 font-mono text-blue-600 font-bold"><?= $row['count'] ?></td>
                        <td class="p-3">
                            <div class="w-full bg-gray-200 rounded-full h-2.5">
                                <div class="bg-blue-600 h-2.5 rounded-full" style="width: <?= $percent ?>%"></div>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<!-- 4. SHORTCUT / QUICK ACTIONS -->
<h3 class="text-lg font-bold text-gray-800 mb-4 border-b pb-2 border-gray-200">Menu Cepat</h3>
<div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4">
    
    <a href="crud_produk?view=add" class="flex flex-col items-center justify-center bg-white p-4 rounded-xl border border-gray-200 hover:border-red-500 hover:shadow-lg transition group text-center h-28">
        <div class="w-10 h-10 bg-red-100 text-red-600 rounded-full flex items-center justify-center mb-2 group-hover:bg-red-600 group-hover:text-white transition">
            <i class="fa-solid fa-plus"></i>
        </div>
        <span class="text-xs font-bold text-gray-700 group-hover:text-red-600">Tambah Mobil</span>
    </a>

    <a href="crud_promo?view=add" class="flex flex-col items-center justify-center bg-white p-4 rounded-xl border border-gray-200 hover:border-purple-500 hover:shadow-lg transition group text-center h-28">
        <div class="w-10 h-10 bg-purple-100 text-purple-600 rounded-full flex items-center justify-center mb-2 group-hover:bg-purple-600 group-hover:text-white transition">
            <i class="fa-solid fa-tags"></i>
        </div>
        <span class="text-xs font-bold text-gray-700 group-hover:text-purple-600">Buat Promo</span>
    </a>

    <a href="crud_artikel?view=add" class="flex flex-col items-center justify-center bg-white p-4 rounded-xl border border-gray-200 hover:border-yellow-500 hover:shadow-lg transition group text-center h-28">
        <div class="w-10 h-10 bg-yellow-100 text-yellow-600 rounded-full flex items-center justify-center mb-2 group-hover:bg-yellow-600 group-hover:text-white transition">
            <i class="fa-solid fa-pen-nib"></i>
        </div>
        <span class="text-xs font-bold text-gray-700 group-hover:text-yellow-600">Tulis Artikel</span>
    </a>

    <a href="credit_settings" class="flex flex-col items-center justify-center bg-white p-4 rounded-xl border border-gray-200 hover:border-green-500 hover:shadow-lg transition group text-center h-28">
        <div class="w-10 h-10 bg-green-100 text-green-600 rounded-full flex items-center justify-center mb-2 group-hover:bg-green-600 group-hover:text-white transition">
            <i class="fa-solid fa-percent"></i>
        </div>
        <span class="text-xs font-bold text-gray-700 group-hover:text-green-600">Update Bunga</span>
    </a>

    <a href="settings" class="flex flex-col items-center justify-center bg-white p-4 rounded-xl border border-gray-200 hover:border-gray-500 hover:shadow-lg transition group text-center h-28">
        <div class="w-10 h-10 bg-gray-100 text-gray-600 rounded-full flex items-center justify-center mb-2 group-hover:bg-gray-600 group-hover:text-white transition">
            <i class="fa-solid fa-gear"></i>
        </div>
        <span class="text-xs font-bold text-gray-700 group-hover:text-gray-600">Profil Web</span>
    </a>

    <a href="change_password" class="flex flex-col items-center justify-center bg-white p-4 rounded-xl border border-gray-200 hover:border-orange-500 hover:shadow-lg transition group text-center h-28">
        <div class="w-10 h-10 bg-orange-100 text-orange-600 rounded-full flex items-center justify-center mb-2 group-hover:bg-orange-600 group-hover:text-white transition">
            <i class="fa-solid fa-lock"></i>
        </div>
        <span class="text-xs font-bold text-gray-700 group-hover:text-orange-600">Ganti Pass</span>
    </a>

</div>

<?php require 'includes/footer.php'; ?>